defmodule Web.PageController do
  use Web, :controller

  def home(conn, _params) do
    # The home page is often custom made,
    # so skip the default app layout.
    render(conn, :home, layout: false)
  end

  def parties(conn, %{"nom" => nom }) do
    conn = put_session(conn, :joueur, nom)
    parties =
      Jeu.lister_parties()
      |> Enum.map(fn {id, {pid, titre}} -> {id, titre} end)

    render(conn, :parties, parties: parties, nom: nom)
  end

  def nouvelle(conn, _params) do
    {id, _} = Jeu.créer_partie(Jeu.Huit)
    redirect(conn, to: ~p"/jeu/#{id}")
  end
end
